/*
  Bombing Run scoreboard.
  
  Author Mark Caldwell aka W@rHe@d of The Reliquary
 */

class UTBRScoreboardPanel extends UTONSScoreboardPanel;

var float MiscFontIx;
var float MiscFontScale;
var float NameHeight;
var float ClanHeight;
var float MiscHeight;
var float startingY;
var float BetweenPlayerPad;
var float HighLightTopAdjust;
var float HighLightBottomAdjust;
var int maxPlayerCount;
var int playerCount;


function string GetClanTagStr(UTPlayerReplicationInfo PRI)
{
	local WorldInfo WI;
	
	WI = UTHudSceneOwner.GetWorldInfo();
    
    if ((WI != none) && (UTBRGame(WI.Game).Test_ClanTags))
    {   
        return "[Clan]";
    }
    
    return super.GetClanTagStr(PRI);
}

//return accurate height of text.
//formula like Fonts[FontIndex].CharHeight * FontScale * MainPerc
//is grossly inaccurate
function float GetHeight(float FontIndex, float FontScale)
{
    local float XL, YL;
    
	StrLen("W", XL, YL, FontIndex, FontScale * MainPerc);
	
	return YL;
}

//return width of text
function float GetWidth(float FontIndex, float FontScale)
{
    local float XL, YL;
    
	StrLen("W", XL, YL, FontIndex, FontScale * MainPerc);
	
	return XL;
}

function DrawScoreHeader()
{
    SetPlayerCounts();
    SetHeaderStrings();    
    HeaderTitle_Name =  HeaderTitle_Name $ "  (" $ playerCount $ " players)";
        
    super.DrawScoreHeader();
}

function DrawHighlight(UTPlayerReplicationInfo PRI, float YPos, float CellHeight, float FontScale)
{
    startingY = YPos;
    super.DrawHighlight(PRI, YPos + (HighLightTopAdjust * ResolutionScale * FontScale), CellHeight + (HighLightBottomAdjust * ResolutionScale * FontScale), FontScale);
}

//set maxPlayerCount and playerCount vars
function SetPlayerCounts()
{
	local WorldInfo WI;
	local int savIx;
	
	WI = UTHudSceneOwner.GetWorldInfo();
	
	if ((WI == none) || (UTGameReplicationInfo(WI.GRI) == None))
	{
	    return;
	}
	
    savIx = AssociatedTeamIndex;
    
    //get red team count
    AssociatedTeamIndex = 0;
	PRIList.Length = 0;    
    GetPRIList(UTGameReplicationInfo(WI.GRI));
    maxPlayerCount = PRIList.Length;
    if (savIx == AssociatedTeamIndex)
    {
        playerCount = PRIList.Length;
    }

    //get blue team count
    AssociatedTeamIndex = 1;
	PRIList.Length = 0;    
    GetPRIList(UTGameReplicationInfo(WI.GRI));
    if (PRIList.Length > maxPlayerCount)
    {
        maxPlayerCount = PRIList.Length;	    
    }
    
    if (savIx == AssociatedTeamIndex)
    {
        playerCount = PRIList.Length;
    }    
    
    AssociatedTeamIndex = savIx;
	PRIList.Length = 0;
}

//copied and modified from base class for BR.
//we add more info, support more players, and various fixes
/**
 * Figure a way to fit the data.  This will probably be specific to each game type
 *
 * @Param	GRI 				The Game ReplicationIfno
 * @Param	FontIndex			The Index to use for the main text
 * @Param 	ClanTagFontIndex	The Index to use for the Clan Tag
 * @Param	MiscFontIndex		The Index to use for the Misc tag
 * @Param	FontSCale			The final font scaling factor to use if all else fails
 * @Param	bPrimeList			Should only be true the first call.  Will build a list of
 *								who needs to be checked.
*/
function float AutoFit(UTGameReplicationInfo GRI, out int FontIndex,out int ClanTagFontIndex,
					out int MiscFontIndex, out float FontScale, bool bPrimeList)
{
	local float CellHeight;
	local bool bRecurse;
	local float oldFontScale;
	local float lineBottomPad;
    		

	// We need to prime our list, so do that first.
	if ( bPrimeList )
	{
		if ( UTHudSceneOwner.IsGame() )
		{
			GetPRIList(GRI);

			if (bInteractive)
			{
				if (SelectedPI != INDEX_None )
				{
					CheckSelectedPRI();
				}
			}			
		}
		else
		{
			// Create Fake Entries for the editor
			PRIList.Length = EditorTestNoPlayers;
		}
	}


    //must base this on a percent of current name font.
    //was using fontindex 0 and (FontScale * MainPerc) but that didn't work in some resolutions
    MiscFontIndex = FontIndex;
    MiscFontScale = (FontScale * MainPerc) * 0.5;
    MiscFontScale = FClamp(MiscFontScale, 0.4f, 1.0f);
        
    MiscFontIx = MiscFontIndex;
    
    //these calculations are totally inaccurate
	// Calculate the Actual Cell Height given all the data
	//CellHeight  = Fonts[FontIndex].CharHeight * MainPerc * FontScale + (HighlightPad * 2 * ResolutionScale) - MiscPosAdjust;
	//CellHeight += ClanTagFontIndex >= 0 ? (Fonts[ClanTagFontIndex].CharHeight * FontScale) + (PlayerNamePad * ResolutionScale) - ClanPosAdjust : 0.0f;
	//CellHeight += MiscFontIndex >= 0 ? (Fonts[MiscFontIndex].CharHeight * FontScale) + (PlayerNamePad * ResolutionScale) : 0.0f;
	
	PlayerNamePad = 0;
	
    //padding in between players
    BetweenPlayerPad = 5;
    
    //UTSScoreboardPanel increments ypos by highlightpad every player, so turn it off as it messes up our calculations.
    //it's incremented like that to adjust the vertical position of highlight but doing that every player adds
    //unneeded spacing between players when this adjustment only needs to be done once when drawing the highlight.
    //so instead we use HighLightTopAdjust and HighLightBottomAdjust to make any needed adjustments
	HighlightPad = 0;
	
	//adjust highlight so edges are proper distance from edges of player info
	HighLightTopAdjust = -7;
    HighLightBottomAdjust = 5;
    
    //we don't need this padding at the moment as the font itself has plenty of white space to use for padding
    lineBottomPad = 0;

    //note: it's important to keep the vertical spacing of the format consistant 
    //across all size changes, or else it might not fit the new font scale passed in recursive call.
    //highlist adjustments below will not affect vertical spacing.
    //if we uniformly apply FontScale to everything then we should be able to use the same format at any scale.
        	 
    ClanHeight = 0;
    if (ClanTagFontIndex >= 0)
    {    
        ClanHeight = GetHeight(ClanTagFontIndex, FontScale) + (lineBottomPad * ResolutionScale * FontScale);
    }
	NameHeight  = GetHeight(FontIndex, FontScale) + (lineBottomPad * ResolutionScale * FontScale);
	MiscHeight = GetHeight(MiscFontIndex, MiscFontScale) + (lineBottomPad * ResolutionScale * FontScale);
	
	CellHeight = ClanHeight + NameHeight + MiscHeight;
	   
    CellHeight += (BetweenPlayerPad * ResolutionScale * FontScale);

	

    //for br we display a single format for both red and blue by using maxPlayerCount, as it's
    //annoying to see one side in one format and the other side in another format
    
	// Check to see if we fit
	if ( (CellHeight * maxPlayerCount) > Canvas.ClipY )
	{
		bRecurse = false;		// By default, don't recurse

        //adjusted bottom clamp to allow for smaller font. nice to see all the players.
		if ((FontScale > 0.5) && bPrimeList)
		{
		    oldFontScale = FontScale;
			FontScale = FClamp( (Canvas.ClipY/(CellHeight * maxPlayerCount)), 0.5f, 1.0f );
			FontScale -= 0.01; //allow for a little computational deviation when recursive call recalculates board height

			//had to fix this because it wasn't always recursing and it should if scale changes, but
            //we will only allow this to happen once to avoid infinite recursion 
			//bRecurse = (FontScale <= 0.75);
			bRecurse = (FontScale != oldFontScale);			
		}
		//never take this line out! this has caused endless confusion and frustration among UT3 players.
		//and now with br we have more critcal info on it.
		//else if ( MiscFontIndex > 0 || (ClanTagFontIndex == 0 && MiscFontIndex == 0) )
		//{
		//	// MiscFontIndex is the first to go
		//	MiscFontIndex--;
		//	bRecurse = true;
		//}
		else if ( ClanTagFontIndex >= 0 )
		{
			// Then the Clan Tag
			ClanTagFontIndex--;
			
			//more broken recursion. you would always want to recurse for any changes made
			//bRecurse = (ClanTagFontIndex >= 0);
			bRecurse = true;
		}

		// If we adjusted the ClanTag or Misc sizes, we need to retest the fit.
		if (bRecurse)
		{
			return AutoFit(GRI, FontIndex, ClanTagFontIndex, MiscFontIndex, FontScale, false);
		}
	}

    //this wasn't needed once recursion was fixed 
	//CellHeight  = Fonts[FontIndex].CharHeight * MainPerc * FontScale + (HighlightPad * 2 * ResolutionScale) - MiscPosAdjust;
	//CellHeight += ClanTagFontIndex >= 0 ? (Fonts[ClanTagFontIndex].CharHeight * FontScale) + (PlayerNamePad * ResolutionScale) - ClanPosAdjust : 0.0f;
	//CellHeight += MiscFontIndex >= 0 ? (Fonts[MiscFontIndex].CharHeight * FontScale) + (PlayerNamePad * ResolutionScale) : 0.0f;
	          
	return CellHeight;
}

function string GetRightMisc(UTPlayerReplicationInfo PRI)
{
    return "";
}

function string GetLeftMisc(UTPlayerReplicationInfo PRI)
{
    return "";
}

function DrawClanTag(UTPlayerReplicationInfo PRI, float X, out float YPos, int FontIndex, float FontScale)
{
    super.DrawClanTag(PRI, X, YPos, FontIndex, FontScale);
    YPos = startingY + ClanHeight;
}

//draw BR extra info line.
//UT3 extra info such as ping does not display if player count is at a certain level, so for
//br we turn it off and display our own.
//in BR we always display it by scaling it's font down.	
function DrawMisc(UTPlayerReplicationInfo PRI, float NameOfst, out float YPos, int FontIndex, float FontScale)
{
	local string sOutput;
	local UTBRPlayerManager pm;
	local WorldInfo WI;
	local string temp;

    YPos = startingY + ClanHeight + NameHeight; 
	
	WI = UTHudSceneOwner.GetWorldInfo();
	
    //they don't replicate pri kills so we gotta do the below
	if (UTBRGame(WI.Game) != none)
	{
		pm = UTBRGame(WI.Game).GetPlayerManager(PRI);
		if (pm != none)
		{
		    PRI.Kills = pm.Kills;
        }
    }
      
    sOutput = "    Kills: " $ PRI.Kills $ " Deaths: " $ string(int(PRI.Deaths)) $ " Net: " $ string(int(PRI.Kills - PRI.Deaths)) $ "  ";
    
    temp = GetPingString(PRI);
    if (temp != "")
    {    
        sOutput = sOutput $ temp $ "  ";
    }
    
    //this doesn't work. location always blank.
    //if ( WI.GRI.OnSameTeam(PRI, PlayerOwner) )
	//{
	//	sOutput = sOutput $ PRI.GetLocationName();
	//}
        
    if ((! PRI.bReadyToPlay) && (! PRI.bBot) && UTBRGame(WI.Game).IsPendingMatch)
    {
        sOutput = sOutput $ "NOT READY";
    }
    
	DrawString(sOutput, NameOfst, YPos, MiscFontIx, MiscFontScale);
}

//return ping and online time the way we want it for br
function string GetPingString(UTPlayerReplicationInfo PRI)
{
	local int TotalSeconds, Hours, Minutes, Seconds;
	local string TimeString;
	local bool bHasHours;
	local string ret;

	if (PRI.WorldInfo.NetMode != NM_Standalone)
	{
		TotalSeconds = PRI.WorldInfo.GRI.ElapsedTime - PRI.StartTime;
			
		hours = TotalSeconds/3600;
		if ( hours > 0 )
		{
			TimeString = Hours$":";
			TotalSeconds -= 3600*Hours;
			bHasHours = true;
		}
		minutes = TotalSeconds/60;
		if ( bHasHours && (minutes < 10) )
		{
			TimeString = TimeString$"0";
		}
		TimeString = TimeString$minutes$":";

		seconds = TotalSeconds - 60*minutes;
		if ( seconds < 10 )
		{
			TimeString = TimeString$"0";
		}
		TimeString = TimeString$seconds;
		
		if (PRI.bBot)
		{
		   ret = "Bot";
        }
        else
        {
           ret = "Ping " $ string(4*PRI.Ping);
        }
		
		ret = ret $ "  " $ TimeString;
		
		return ret;
	}
	
	return "";
}

defaultproperties
{
   FlagTexture=Texture2D'UI_HUD.HUD.UI_HUD_BaseA'
   FlagCoords=(U=600.000000,V=237.000000,UL=23.000000,VL=23.000000)
   Begin Object Name=WidgetEventComponent ObjName=WidgetEventComponent Archetype=UIComp_Event'UTGame.Default__UTONSScoreboardPanel:WidgetEventComponent'
      ObjectArchetype=UIComp_Event'UTGame.Default__UTONSScoreboardPanel:WidgetEventComponent'
   End Object
   EventProvider=WidgetEventComponent
   Name="Default__UTBRScoreboardPanel"
   ObjectArchetype=UTONSScoreboardPanel'UTGame.Default__UTONSScoreboardPanel'
}
